/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterJSParenthesesNode
extends FormatterBlockWithBeginEndNode {
    private boolean asWrapper;
    private boolean hasCommentBeforeOpen;
    private boolean hasCommentBeforeClose;
    private NodeTypes.TypeBracket parenthesesType;

    public FormatterJSParenthesesNode(IFormatterDocument document, boolean asWrapper, boolean hasCommentBeforeOpen, boolean hasCommentBeforeClose, NodeTypes.TypeBracket type) {
        super(document);
        this.asWrapper = asWrapper;
        this.hasCommentBeforeOpen = hasCommentBeforeOpen;
        this.hasCommentBeforeClose = hasCommentBeforeClose;
        this.parenthesesType = type;
    }

    public FormatterJSParenthesesNode(IFormatterDocument document, boolean asWrapper) {
        this(document, asWrapper, false, false, null);
    }

    public FormatterJSParenthesesNode(IFormatterDocument document, NodeTypes.TypeBracket type) {
        this(document, false, false, false, type);
    }

    public int getSpacesCountBefore() {
        if (this.isAsWrapper()) {
            return 1;
        }
        if (this.parenthesesType != null) {
            switch (this.parenthesesType) {
                case DECLARATION_PARENTHESIS: {
                    return this.getInt("js.formatter.spaces.before.declaration.parentheses.opening");
                }
                case ARRAY_PARENTHESIS: 
                case INVOCATION_PARENTHESIS: {
                    return this.getInt("js.formatter.spaces.before.invocation.parentheses.opening");
                }
                case ARRAY_SQUARE: {
                    return this.getInt("js.formatter.spaces.before.array.access.parentheses.opening");
                }
                case CONDITIONAL_PARENTHESIS: {
                    return this.getInt("js.formatter.spaces.before.conditional.parentheses.opening");
                }
                case LOOP_PARENTHESIS: {
                    return this.getInt("js.formatter.spaces.before.loop.parentheses.opening");
                }
            }
            return this.getInt("js.formatter.spaces.before.parentheses");
        }
        return super.getSpacesCountBefore();
    }

    protected void acceptBody(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        int spacesBeforeBody = this.getSpacesBeforeBody();
        if (spacesBeforeBody > 0) {
            this.writeSpaces(visitor, context, spacesBeforeBody);
        }
        super.acceptBody(context, visitor);
        int spacesAfterBody = this.getSpacesAfterBody();
        if (spacesAfterBody > 0) {
            this.writeSpaces(visitor, context, spacesAfterBody);
        }
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return !this.isAddingBeginNewLine();
    }

    public boolean isAsWrapper() {
        return this.asWrapper;
    }

    public void setHasCommentBeforeOpen(boolean hasCommentBeforeOpen) {
        this.hasCommentBeforeOpen = hasCommentBeforeOpen;
    }

    public void setHasCommentBeforeClose(boolean hasCommentBeforeClose) {
        this.hasCommentBeforeClose = hasCommentBeforeClose;
    }

    protected boolean isAddingBeginNewLine() {
        return this.hasCommentBeforeOpen;
    }

    protected boolean isAddingEndNewLine() {
        return this.hasCommentBeforeClose && !this.asWrapper;
    }

    private int getSpacesBeforeBody() {
        if (this.isAsWrapper() || this.parenthesesType == null) {
            return 0;
        }
        switch (this.parenthesesType) {
            case DECLARATION_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.after.declaration.parentheses.opening");
            }
            case ARRAY_PARENTHESIS: 
            case INVOCATION_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.after.invocation.parentheses.opening");
            }
            case ARRAY_SQUARE: {
                return this.getInt("js.formatter.spaces.after.array.access.parentheses.opening");
            }
            case CONDITIONAL_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.after.conditional.parentheses.opening");
            }
            case LOOP_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.after.loop.parentheses.opening");
            }
        }
        return this.getInt("js.formatter.spaces.after.parentheses");
    }

    private int getSpacesAfterBody() {
        if (this.isAsWrapper() || this.parenthesesType == null) {
            return 0;
        }
        switch (this.parenthesesType) {
            case DECLARATION_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.before.declaration.parentheses.closing");
            }
            case ARRAY_PARENTHESIS: 
            case INVOCATION_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.before.invocation.parentheses.closing");
            }
            case ARRAY_SQUARE: {
                return this.getInt("js.formatter.spaces.before.array.access.parentheses.closing");
            }
            case CONDITIONAL_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.before.conditional.parentheses.closing");
            }
            case LOOP_PARENTHESIS: {
                return this.getInt("js.formatter.spaces.before.loop.parentheses.closing");
            }
        }
        return this.getInt("js.formatter.spaces.before.parentheses.closing");
    }
}

